## Installation

Make sure Python 3 is installed. Then, create the conda environment and install the required libraries using environment.yml for running Shallow Models, and Time series foundation models (TSFMs).


```sh
conda env create -f environment.yml
conda activate tf-env
```

For Adaptive Random Forest, first ensure Python 3 is installed. Then, install the River library and create the conda environment using arf_environment.yml

```sh
conda env create -f arf_environment.yml
conda activate river-env
```

To set up Chronos, follow these instructions from the official GitHub repository:

```sh
conda activate tf-env
!pip install autogluon
If keras3 is installed, then install the backwards-compatible tf-keras package with `!pip install tf-keras`.
```

To set up TTM, follow these instructions from the official GitHub repository:

```sh
conda activate tf-env
# Clone the ibm/tsfm
! git clone https://github.com/ibm-granite/granite-tsfm.git
! ls

# Change directory. Move inside the tsfm repo.
%cd granite-tsfm
! ls

# Relax requirement for python version < 3.12
! sed -i.orig 's/3\.12/3.13/g' pyproject.toml

# Install the tsfm library
#! pip install ".[notebooks]"
#! python3 -m pip install ".[notebooks]"
! pip3 install ".[notebooks]"
```
To set up Lag-Llama, follow these instructions from the official GitHub repository:
```sh
!git clone -b update-gluonts https://github.com/time-series-foundation-models/lag-llama/
cd lag-llama
!pip install -r requirements.txt  
!pip install -U torch torchvision
!huggingface-cli download time-series-foundation-models/Lag-Llama lag-llama.ckpt --local-dir lag-llama
cd lag-llama
```